

def print_graph_stats(g):
    import torch

    print('|V|={}, |E|={}'.format(g.number_of_nodes(), g.number_of_edges()))
    print('train: {}, valid: {}, test: {}'.format(torch.sum(g.ndata['train_mask']),
                                                  torch.sum(g.ndata['val_mask']),
                                                  torch.sum(g.ndata['test_mask'])))
    
def print_yellow(*args):
    """
    Print the given messages in yellow color in the terminal.

    Args:
    *args: Variable length argument list.
    """
    msg = ' '.join(map(str, args))
    print("\033[93m{}\033[00m".format(msg))

def print_red(*args):
    """
    Print the given messages in red color in the terminal.

    Args:
    *args: Variable length argument list.
    """
    msg = ' '.join(map(str, args))
    print("\033[91m{}\033[00m".format(msg))

def print_green(*args):
    """
    Print the given messages in green color in the terminal.

    Args:
    *args: Variable length argument list.
    """
    msg = ' '.join(map(str, args))
    print("\033[92m{}\033[00m".format(msg))

def print_blue(*args):
    """
    Print the given messages in blue color in the terminal.

    Args:
    *args: Variable length argument list.
    """
    msg = ' '.join(map(str, args))
    print("\033[94m{}\033[00m".format(msg))